	function [Asave, Bsave] = bairstow(A)
	% 
	% Extracts factors of the form x^4 + aix^2 +bi
	% out of a polynomial A = E*conj(E).
	% The output is the vectors Asave and Bsave on the form [a0 a1 ..] and
	% [b0 b1 ...] respectively. The function uses matlab functions for factorization.
	% If there is a real factor, then the corresponding ai is set to inf to show this.
	
	% Author: 			Per Loewenborg
    % Modified by:		Lw
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
	
	r = roots(A);
	r = sort(r);
	r = r';
	p = [];
	Asave =[];
	Bsave = [];
	while isempty(r) == 0
		if length(r) > 3 
			if (abs(r(1))-abs(r(4))) < 1e-10
				t = abs(real(r(1)));
				u = abs(imag(r(1)));
				p = conv(conv([1 t+j*u],[1 t-j*u]),conv([1 -t+j*u],[1 -t-j*u]));
				Asave =[Asave p(3)];
				Bsave =[Bsave p(5)];
				r = r(5:length(r));   
			else	
				t = abs(real(r(1)));
				p = conv([1 t],[1 -t]);
				Asave = [Asave inf];
				Bsave = [Bsave p(3)];
				r = r(3:length(r));
			end
		else  
			t = abs(real(r(1)));
			p = conv([1 t],[1 -t]);
			Asave = [Asave inf];
			Bsave = [Bsave p(3)];
			r = r(3:length(r));
		end
	end	
